<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // ----------------------
        // Field Agents / Employees
        // ----------------------
        Schema::create('field_agents', function (Blueprint $table) {
            $table->id();

            // Removed FK
            $table->unsignedBigInteger('user_id');

            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();

            // Removed FK
            $table->unsignedBigInteger('team_id')->nullable();

            $table->boolean('is_active')->default(true);
            $table->string('phone')->nullable();
            $table->string('whatsapp_number')->nullable();
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        // ----------------------
        // Task Categories (optional)
        // ----------------------
        Schema::create('field_task_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->timestampsTz();
        });

        // ----------------------
        // Tasks / Jobs
        // ----------------------
        Schema::create('field_tasks', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('agent_id');
            $table->unsignedBigInteger('category_id')->nullable();

            $table->string('title');
            $table->text('description')->nullable();
            $table->enum('status', ['pending','in_progress','completed','cancelled'])->default('pending');
            $table->dateTime('assigned_at')->useCurrent();
            $table->dateTime('due_at')->nullable();
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        // ----------------------
        // Visits / Check-ins
        // ----------------------
        Schema::create('field_visits', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('task_id');
            $table->unsignedBigInteger('contact_id')->nullable();

            $table->string('location_lat')->nullable();
            $table->string('location_lng')->nullable();
            $table->timestamp('check_in_at')->nullable();
            $table->timestamp('check_out_at')->nullable();
            $table->text('notes')->nullable();
            $table->timestampsTz();
        });

        // ----------------------
        // Attendance
        // ----------------------
        Schema::create('field_attendance', function (Blueprint $table) {
            $table->id();

            // Removed FK
            $table->unsignedBigInteger('agent_id');

            $table->date('attendance_date');
            $table->timestamp('check_in_at')->nullable();
            $table->string('check_in_location')->nullable();
            $table->timestamp('check_out_at')->nullable();
            $table->string('check_out_location')->nullable();
            $table->enum('status', ['present','absent','leave'])->default('present');
            $table->timestampsTz();
            $table->unique(['agent_id','attendance_date']);
        });

        // ----------------------
        // Reports / Notes
        // ----------------------
        Schema::create('field_reports', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('task_id');
            $table->unsignedBigInteger('agent_id');

            $table->text('report_text')->nullable();
            $table->json('attachments')->nullable();
            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('field_reports');
        Schema::dropIfExists('field_attendance');
        Schema::dropIfExists('field_visits');
        Schema::dropIfExists('field_tasks');
        Schema::dropIfExists('field_task_categories');
        Schema::dropIfExists('field_agents');
    }
};
