<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // ----------------------
        // Companies / Organizations
        // ----------------------
        Schema::create('crm_companies', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('industry')->nullable();
            $table->string('website')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        // ----------------------
        // Contacts / Customers
        // ----------------------
        Schema::create('crm_contacts', function (Blueprint $table) {
            $table->id();

            // Removed FK
            $table->unsignedBigInteger('company_id')->nullable();

            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->string('email')->nullable()->unique();
            $table->string('phone')->nullable();
            $table->string('whatsapp_number')->nullable();
            $table->string('job_title')->nullable();
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        // ----------------------
        // Leads / Opportunities
        // ----------------------
        Schema::create('crm_leads', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('contact_id')->nullable();
            $table->unsignedBigInteger('assigned_to')->nullable();

            $table->string('title');
            $table->text('description')->nullable();
            $table->enum('status', ['new','contacted','qualified','lost','converted'])->default('new');
            $table->decimal('potential_value', 15, 2)->nullable();
            $table->date('expected_close_date')->nullable();
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        // ----------------------
        // Deals / Sales
        // ----------------------
        Schema::create('crm_deals', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('lead_id')->nullable();
            $table->unsignedBigInteger('assigned_to')->nullable();

            $table->decimal('amount', 15, 2);
            $table->enum('status', ['open','won','lost','closed'])->default('open');
            $table->date('closed_at')->nullable();
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        // ----------------------
        // Activities / Tasks / Notes
        // ----------------------
        Schema::create('crm_activities', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('lead_id')->nullable();
            $table->unsignedBigInteger('deal_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();

            $table->enum('type', ['call','email','meeting','note','task','whatsapp']);
            $table->text('description')->nullable();
            $table->dateTime('scheduled_at')->nullable();
            $table->enum('status', ['pending','completed','cancelled'])->default('pending');
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        // ----------------------
        // Communication logs
        // ----------------------
        Schema::create('crm_communications', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('lead_id')->nullable();
            $table->unsignedBigInteger('contact_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();

            $table->enum('channel', ['email','call','sms','meeting','whatsapp'])->default('email');
            $table->text('notes')->nullable();
            $table->string('whatsapp_number')->nullable();
            $table->text('whatsapp_message')->nullable();
            $table->enum('whatsapp_status', ['pending','sent','delivered','read'])->nullable();
            $table->timestamp('communicated_at')->useCurrent();
            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('crm_communications');
        Schema::dropIfExists('crm_activities');
        Schema::dropIfExists('crm_deals');
        Schema::dropIfExists('crm_leads');
        Schema::dropIfExists('crm_contacts');
        Schema::dropIfExists('crm_companies');
    }
};
