<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // ------------------------------
        // Purchase Orders
        // ------------------------------
        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            // Removed FKs
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('supplier_id')->nullable();

            $table->string('reference')->nullable();
            $table->date('order_date');
            $table->date('expected_date')->nullable();
            $table->enum('status', ['draft', 'ordered', 'received', 'cancelled'])->default('draft');
            $table->decimal('total', 15, 2)->default(0);

            $table->timestampsTz();
            $table->softDeletesTz();

            $table->index(['company_id','branch_id','supplier_id','status']);
        });

        // ------------------------------
        // Purchase Order Items
        // ------------------------------
        Schema::create('purchase_order_items', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('purchase_order_id')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();

            $table->decimal('quantity', 15, 2)->default(0);
            $table->decimal('cost_price', 15, 2)->default(0);
            $table->decimal('tax', 15, 2)->default(0);
            $table->decimal('total', 15, 2)->default(0);

            $table->timestampsTz();
        });

        // ------------------------------
        // Purchase Payments
        // ------------------------------
        Schema::create('purchase_payments', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            // Removed FKs
            $table->unsignedBigInteger('purchase_order_id')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('paid_by')->nullable();

            $table->enum('payment_type', ['cash', 'bank', 'card', 'online'])->default('cash');
            $table->decimal('amount', 15, 2)->default(0);
            $table->string('reference')->nullable();
            $table->date('payment_date');

            $table->timestampsTz();
        });

        // ------------------------------
        // Purchase Order Status History
        // ------------------------------
        Schema::create('purchase_order_status', function (Blueprint $table) {
            $table->id();

            // Removed FKs
            $table->unsignedBigInteger('purchase_order_id')->nullable();
            $table->unsignedBigInteger('changed_by')->nullable();

            $table->enum('status', ['draft', 'ordered', 'received', 'cancelled']);
            $table->text('note')->nullable();

            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_order_status');
        Schema::dropIfExists('purchase_payments');
        Schema::dropIfExists('purchase_order_items');
        Schema::dropIfExists('purchase_orders');
    }
};
