<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // --------------------------------
        // Accounts (unlimited hierarchy)
        // --------------------------------
        Schema::create('accounts', function (Blueprint $table) {
            $table->id();

            // Removed FK → store as plain bigint
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();
            
            $table->string('name');
            $table->string('code')->nullable()->unique();
            $table->enum('type', ['asset','liability','equity','income','expense']);
            $table->decimal('opening_balance', 15, 2)->default(0);

            // Self reference removed
            $table->unsignedBigInteger('parent_id')->nullable();

            $table->integer('level')->default(0); 
            $table->timestampsTz();
        });

        // --------------------------------
        // Vouchers
        // --------------------------------
        Schema::create('vouchers', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();

            $table->string('reference')->nullable();
            $table->text('description')->nullable();
            $table->date('voucher_date');
            $table->decimal('total_debit', 15, 2)->default(0);
            $table->decimal('total_credit', 15, 2)->default(0);
            $table->boolean('is_synced')->default(false);

            $table->timestampsTz();
        });

        // --------------------------------
        // Voucher Lines
        // --------------------------------
        Schema::create('voucher_lines', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('voucher_id')->nullable();
            $table->unsignedBigInteger('account_id')->nullable();

            $table->decimal('debit', 15, 2)->default(0);
            $table->decimal('credit', 15, 2)->default(0);
            $table->text('description')->nullable();

            $table->timestampsTz();
        });

        // --------------------------------
        // Journal Entries
        // --------------------------------
        Schema::create('journal_entries', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->unsignedBigInteger('voucher_line_id')->nullable();

            $table->decimal('debit', 15, 2)->default(0);
            $table->decimal('credit', 15, 2)->default(0);
            $table->text('description')->nullable();

            $table->timestampsTz();
        });

        // --------------------------------
        // Account Ledgers
        // --------------------------------
        Schema::create('account_ledgers', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('account_id')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();

            $table->decimal('balance', 15, 2)->default(0);

            $table->timestampsTz();
        });

        // --------------------------------
        // Trial Balances (Optional)
        // --------------------------------
        Schema::create('trial_balances', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();

            $table->date('period_start');
            $table->date('period_end');
            $table->decimal('total_debit', 15, 2)->default(0);
            $table->decimal('total_credit', 15, 2)->default(0);

            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('trial_balances');
        Schema::dropIfExists('account_ledgers');
        Schema::dropIfExists('journal_entries');
        Schema::dropIfExists('voucher_lines');
        Schema::dropIfExists('vouchers');
        Schema::dropIfExists('accounts');
    }
};
