<?php

namespace App\Modules\UserProfile\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSetting extends Model
{
    use HasFactory;

    protected $table = 'user_settings';

    protected $fillable = [
        'user_profile_id',
        'key',
        'value',
    ];

    protected $casts = [
        'value' => 'array',
    ];

    public function profile()
    {
        return $this->belongsTo(UserProfile::class);
    }
}
