<?php

namespace App\Modules\UserProfile\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserProfile extends Model
{
    use HasFactory;

    protected $table = 'user_profiles';

    protected $fillable = [
        'user_id',
        'first_name',
        'last_name',
        'gender',
        'dob',
        'phone',
        'email',
        'address',
        'city',
        'state',
        'country',
        'zip',
        'bio',
        'social_links',
        'skills',
        'hobbies',
        'preferences',
        'settings',
        'metadata',
    ];

    protected $casts = [
        'dob' => 'date',
        'social_links' => 'array',
        'skills' => 'array',
        'hobbies' => 'array',
        'preferences' => 'array',
        'settings' => 'array',
        'metadata' => 'array',
    ];

    // Relationships
    public function skills()
    {
        return $this->hasMany(UserSkill::class);
    }

    public function hobbies()
    {
        return $this->hasMany(UserHobby::class);
    }

    public function socialLinks()
    {
        return $this->hasMany(UserSocialLink::class);
    }

    public function preferencesRelation()
    {
        return $this->hasMany(UserPreference::class);
    }

    public function settingsRelation()
    {
        return $this->hasMany(UserSetting::class);
    }

    public function metadataRelation()
    {
        return $this->hasMany(UserMetadata::class);
    }
}
