<?php

namespace App\Modules\Theme\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ThemeController extends Controller
{
    private $themes = [
        ['id' => 1, 'name' => 'Light', 'active' => true],
        ['id' => 2, 'name' => 'Dark', 'active' => false],
        ['id' => 3, 'name' => 'Blue', 'active' => false],
    ];

    public function index()
    {
        return response()->json([
            'status' => 'success',
            'themes' => $this->themes
        ]);
    }

    public function setTheme(Request $request)
    {
        $id = $request->input('id');

        foreach ($this->themes as &$theme) {
            $theme['active'] = ($theme['id'] == $id);
        }

        return response()->json([
            'status' => 'success',
            'message' => "Theme ID {$id} is now active",
            'themes' => $this->themes
        ]);
    }

    public function test()
    {
        return response()->json(['message' => 'Theme module is working!']);
    }
}
