<?php

namespace App\Modules\SuperAdmin\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SuperAdminController extends Controller
{
    private $users = [
        ['id' => 1, 'name' => 'Alice', 'role' => 'superadmin'],
        ['id' => 2, 'name' => 'Bob', 'role' => 'admin'],
    ];

    public function index()
    {
        return response()->json([
            'status' => 'success',
            'users' => $this->users
        ]);
    }

    public function assignRole(Request $request)
    {
        $data = $request->only(['user_id', 'role']);

        // Example logic: Assign role
        foreach ($this->users as &$user) {
            if ($user['id'] == $data['user_id']) {
                $user['role'] = $data['role'];
            }
        }

        return response()->json([
            'status' => 'success',
            'message' => "Role '{$data['role']}' assigned to user ID {$data['user_id']}",
            'users' => $this->users
        ]);
    }

    public function revokeRole(Request $request)
    {
        $data = $request->only(['user_id']);

        foreach ($this->users as &$user) {
            if ($user['id'] == $data['user_id']) {
                $user['role'] = 'user';
            }
        }

        return response()->json([
            'status' => 'success',
            'message' => "Role revoked for user ID {$data['user_id']}",
            'users' => $this->users
        ]);
    }

    public function test()
    {
        return response()->json(['message' => 'SuperAdmin module is working!']);
    }
}
