<?php

use Illuminate\Support\Facades\Route;
use App\Modules\InventoryBilling\Http\Controllers\InventoryBillingController;

Route::prefix('inventory-billing')->group(function () {
    Route::get('/test', [InventoryBillingController::class, 'test']); // test route
    Route::get('/invoices', [InventoryBillingController::class, 'index']); // list all invoices
    Route::get('/invoices/{id}', [InventoryBillingController::class, 'show']); // show single invoice
    Route::post('/invoices', [InventoryBillingController::class, 'store']); // create invoice
    Route::put('/invoices/{id}', [InventoryBillingController::class, 'update']); // update invoice
    Route::delete('/invoices/{id}', [InventoryBillingController::class, 'destroy']); // delete invoice
});
