<?php

namespace App\Modules\HRM\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class HRMController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'HRM module is working']);
    }

    // List all employees (sample data)
    public function index()
    {
        $employees = [
            ['id' => 1, 'name' => 'Alice Johnson', 'department' => 'IT', 'status' => 'active'],
            ['id' => 2, 'name' => 'Bob Smith', 'department' => 'HR', 'status' => 'inactive'],
        ];

        return response()->json($employees);
    }

    // Show single employee
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Employee',
            'department' => 'IT',
            'status' => 'active',
            'attendance' => [
                ['date' => '2025-11-01', 'status' => 'present'],
                ['date' => '2025-11-02', 'status' => 'absent']
            ],
            'leave_requests' => [
                ['from' => '2025-12-01', 'to' => '2025-12-05', 'status' => 'approved']
            ]
        ]);
    }

    // Add employee
    public function store(Request $request)
    {
        $data = $request->only(['name', 'department', 'status']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Employee added', 'employee' => $data], 201);
    }

    // Update employee
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'department', 'status']);
        return response()->json(['message' => "Employee {$id} updated", 'employee' => $data]);
    }

    // Delete employee
    public function destroy($id)
    {
        return response()->json(['message' => "Employee {$id} deleted"]);
    }
}
