<?php

use Illuminate\Support\Facades\Route;
use App\Modules\FileManager\Http\Controllers\FileManagerController;

Route::prefix('filemanager')->group(function () {
    Route::get('/test', [FileManagerController::class, 'test']); // test route
    Route::get('/files', [FileManagerController::class, 'index']); // list all files
    Route::get('/files/{id}', [FileManagerController::class, 'show']); // show single file
    Route::post('/files', [FileManagerController::class, 'store']); // upload file
    Route::put('/files/{id}', [FileManagerController::class, 'update']); // update file info
    Route::delete('/files/{id}', [FileManagerController::class, 'destroy']); // delete file
});
