<?php

namespace App\Modules\FieldForce\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class FieldForceController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'FieldForce module is working']);
    }

    // List all agents (sample data)
    public function index()
    {
        $agents = [
            ['id' => 1, 'name' => 'Agent John', 'status' => 'active', 'location' => 'City A'],
            ['id' => 2, 'name' => 'Agent Jane', 'status' => 'inactive', 'location' => 'City B'],
        ];

        return response()->json($agents);
    }

    // Show single agent
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Agent',
            'status' => 'active',
            'tasks' => [
                ['title' => 'Task 1', 'status' => 'pending'],
                ['title' => 'Task 2', 'status' => 'completed']
            ],
            'location' => 'City X'
        ]);
    }

    // Add agent
    public function store(Request $request)
    {
        $data = $request->only(['name', 'status', 'location']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Agent added', 'agent' => $data], 201);
    }

    // Update agent
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'status', 'location']);
        return response()->json(['message' => "Agent {$id} updated", 'agent' => $data]);
    }

    // Delete agent
    public function destroy($id)
    {
        return response()->json(['message' => "Agent {$id} deleted"]);
    }
}
