<?php

namespace App\Modules\DomainManager\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class DomainManagerController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'DomainManager module is working']);
    }

    // List all domains (sample data)
    public function index()
    {
        $domains = [
            ['id' => 1, 'name' => 'example.com', 'status' => 'active'],
            ['id' => 2, 'name' => 'mysite.net', 'status' => 'inactive'],
        ];

        return response()->json($domains);
    }

    // Show single domain
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'sampledomain.com',
            'status' => 'active',
            'dns_records' => [
                ['type' => 'A', 'value' => '192.168.1.1'],
                ['type' => 'MX', 'value' => 'mail.sampledomain.com']
            ]
        ]);
    }

    // Add domain
    public function store(Request $request)
    {
        $data = $request->only(['name', 'status']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Domain added', 'domain' => $data], 201);
    }

    // Update domain
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'status']);
        return response()->json(['message' => "Domain {$id} updated", 'domain' => $data]);
    }

    // Delete domain
    public function destroy($id)
    {
        return response()->json(['message' => "Domain {$id} deleted"]);
    }
}
