<?php

namespace App\Modules\Branch\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class BranchController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Branch module is working']);
    }

    // List all branches (sample data)
    public function index()
    {
        $branches = [
            ['id' => 1, 'name' => 'Head Office', 'location' => 'New York'],
            ['id' => 2, 'name' => 'Branch Office', 'location' => 'Los Angeles'],
        ];

        return response()->json($branches);
    }

    // Show single branch
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Branch',
            'location' => 'Sample Location',
            'manager' => 'John Doe'
        ]);
    }

    // Create branch
    public function store(Request $request)
    {
        $data = $request->only(['name', 'location', 'manager']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Branch created', 'branch' => $data], 201);
    }

    // Update branch
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'location', 'manager']);
        return response()->json(['message' => "Branch {$id} updated", 'branch' => $data]);
    }

    // Delete branch
    public function destroy($id)
    {
        return response()->json(['message' => "Branch {$id} deleted"]);
    }
}
