<?php

namespace App\Modules\Automation\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AutomationController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Automation module is working']);
    }

    // List all automation tasks (sample data)
    public function index()
    {
        $tasks = [
            ['id' => 1, 'name' => 'Send Daily Reports', 'status' => 'active'],
            ['id' => 2, 'name' => 'Cleanup Logs', 'status' => 'inactive'],
        ];

        return response()->json($tasks);
    }

    // Show single task
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Task',
            'status' => 'active',
            'schedule' => 'daily'
        ]);
    }

    // Create task
    public function store(Request $request)
    {
        $data = $request->only(['name', 'status', 'schedule']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Task created', 'task' => $data], 201);
    }

    // Update task
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'status', 'schedule']);
        return response()->json(['message' => "Task {$id} updated", 'task' => $data]);
    }

    // Delete task
    public function destroy($id)
    {
        return response()->json(['message' => "Task {$id} deleted"]);
    }
}
