<?php

namespace App\Core\Models\Accounting;

use Illuminate\Database\Eloquent\Model;

class JournalEntry extends Model
{
    protected $table = 'journal_entries';

    protected $fillable = [
        'uuid',
        'company_id',
        'branch_id',
        'account_id',
        'voucher_line_id',
        'debit',
        'credit',
        'description'
    ];

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function voucherLine()
    {
        return $this->belongsTo(VoucherLine::class);
    }
}
