<?php

namespace App\Modules\AccessControl\Providers;

use Illuminate\Support\ServiceProvider;

class AccessControlServiceProvider extends ServiceProvider
{
    public function register()
    {
        // Services, Repositories, Interfaces bindings go here
    }

    public function boot()
    {
        // Load routes
        $routesPath = __DIR__ . '/../Routes/api.php';
        if (file_exists($routesPath)) {
            $this->loadRoutesFrom($routesPath);
        }

        // Load migrations
        $migrationsPath = __DIR__ . '/../Database/Migrations';
        if (file_exists($migrationsPath)) {
            $this->loadMigrationsFrom($migrationsPath);
        }
    }
}
