<?php
// ============================================================================
// app/Core/Models/Attribute.php
// ============================================================================
namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Attribute extends Model
{
    protected $table = 'user_attributes';

    protected $fillable = [
        'uuid',
        'user_id',
        'company_id',
        'branch_id',
        'attribute_name',
        'value',
        'attribute_type',
        'is_required',
    ];

    protected $casts = [
        'is_required' => 'boolean',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
