<?php

namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CompanyTaxSetting extends Model
{
    protected $table = 'company_tax_settings';

    protected $fillable = [
        'company_id',
        'tax_name',
        'tax_rate',
        'tax_type',
    ];

    protected $casts = [
        'tax_rate' => 'decimal:2',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }
}
