<?php

namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CompanyLimit extends Model
{
    protected $table = 'company_limits';

    protected $fillable = [
        'company_id',
        'max_users',
        'max_branches',
        'max_products',
        'max_invoices_per_month',
        'max_customers',
        'max_suppliers',
        'max_storage_mb',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }
}
