<?php

namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CompanyBillingHistory extends Model
{
    protected $table = 'company_billing_history';

    protected $fillable = [
        'company_id',
        'plan_id',
        'invoice_no',
        'amount',
        'currency',
        'payment_method',
        'status',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function plan(): BelongsTo
    {
        return $this->belongsTo(CompanyPlan::class, 'plan_id');
    }

    public function items(): HasMany
    {
        return $this->hasMany(CompanyBillingHistoryItem::class, 'billing_id');
    }
}
