<?php

namespace App\Core\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use App\Core\Services\TenantService;
use App\Core\Services\ModuleService;

class CoreController extends Controller
{
    public function testCore(): JsonResponse
    {
        return response()->json([
            'status' => true,
            'message' => 'Core layer is ready!',
            'data' => ['core' => 'working']
        ]);
    }
    public function status()
    {
        return response()->json([
            'status' => true,
            'message' => 'Core layer is ready!',
            'data' => ['core' => 'working']
        ]);
    }

    public function modules(ModuleService $moduleService)
    {
        return response()->json($moduleService->getAllModules());
    }
}
